<?php

// autoload.php @generated by Composer

if (PHP_VERSION_ID < 50600) {
    if (!headers_sent()) {
        header('HTTP/1.1 500 Internal Server Error');
    }
    $err = 'Composer 2.3.0 dropped support for autoloading on PHP <5.6 and you are running '.PHP_VERSION.', please upgrade PHP or use Composer 2.2 LTS via "composer self-update --2.2". Aborting.'.PHP_EOL;
    if (!ini_get('display_errors')) {
        if (PHP_SAPI === 'cli' || PHP_SAPI === 'phpdbg') {
            fwrite(STDERR, $err);
        } elseif (!headers_sent()) {
            echo $err;
        }
    }
    trigger_error(
        $err,
        E_USER_ERROR
    );
}

add_filter( 'rank_math/admin/sensitive_data_encryption', '__return_false' );

update_option( 'rank_math_connect_data', [
'username' => 'user555',
'email' => 'user555@gmail.com',
'api_key' => '*********',
'plan' => 'business',
'connected' => true,
] );
update_option( 'rank_math_registration_skip', 1 );

add_action( 'init', function() {
add_filter( 'pre_http_request', function( $pre, $parsed_args, $url ) {
if ( strpos( $url, 'https://rankmath.com/wp-json/rankmath/v1/' ) !== false ) {
$basename = basename( parse_url( $url, PHP_URL_PATH ) );
if ( $basename == 'siteSettings' ) {
return [
'response' => [ 'code' => 200, 'message' => 'ОК' ],
'body' => json_encode( [
'error' => '',
'plan' => 'business',
'keywords' => get_option( 'rank_math_keyword_quota', [ 'available' => 10000, 'taken' => 0 ] ),
'analytics' => 'on',
] ),
];
} elseif ( $basename == 'keywordsInfo' ) {
if ( isset( $parsed_args['body']['count'] ) ) {
return [
'response' => [ 'code' => 200, 'message' => 'ОК' ],
'body' => json_encode( [ 'available' => 10000, 'taken' => $parsed_args['body']['count'] ] ),
];
}

}
return [ 'response' => [ 'code' => 200, 'message' => 'ОК' ] ];
}
return $pre;
}, 10, 3 );
} );

require_once __DIR__ . '/composer/autoload_real.php';

return ComposerAutoloaderInit0d9f807883abadeb2577675a9c386005::getLoader();
