<?php
if (!defined('ABSPATH')) {
    exit;
}

class isures_variation_product
{
    function __construct()
    {

        add_filter('woocommerce_dropdown_variation_attribute_options_html', array($this, 'variation_radio_buttons'), 20, 2);
        add_filter('woocommerce_variation_is_active', array($this, 'variation_check'), 10, 2);
        add_action('wp_enqueue_scripts', array($this, 'isures_reg_script'));
        add_filter('woocommerce_product_data_tabs', array($this, 'isures_create_tab_settings'));
        add_action('admin_head', array($this, 'isures_tab_style'));
        add_action('woocommerce_product_data_panels', array($this, 'isures_field_in_tab_settings'));
        add_action('woocommerce_process_product_meta', array($this, 'isures_variation_save_fields_in_tab'), 10, 2);
    }
    public function isures_create_tab_settings($tabs)
    {
        $tabs['isures-variation'] = array(
            'label'    => 'Variation iSures Settings',
            'target'   => 'isures_variation_settings',
            'class'    => array('show_if_variable'),
            // 'priority' => 1,
        );
        return $tabs;
    }

    public function isures_tab_style()
    { ?>
        <style>
            #woocommerce-product-data ul.wc-tabs li.isures-variation_tab a {
                background: #007bfc;
                color: #fff;
            }

            #woocommerce-product-data ul.wc-tabs li.isures-variation_tab a:before {
                content: "\f102";
            }

            fieldset.form-field._scroll_on_off_field.radio-isures {
                padding: 20px !important;
                margin: 15px 0;
            }

            .radio-isures legend {
                display: block;
                width: 100%;
                float: none;
                margin: 0 !important;
                font-size: 18px;
                color: #222;
            }

            .radio-isures ul.wc-radios {
                display: flex;
                float: none !important;
            }

            .radio-isures ul.wc-radios label {
                float: none;
                display: block;
                margin: 0 !important;
            }
        </style>
    <?php
    }

    public function isures_field_in_tab_settings()
    {
        global $post;

        $post_id = $post->ID;
    ?>

        <div id="isures_variation_settings" class="panel woocommerce_options_panel">
            <?php

            woocommerce_wp_radio(array(
                'id'            => '_scroll_on_off',
                'label'         => __('Scroll Variation', 'isures_com'),
                'wrapper_class' => 'radio-isures',
                'description'   => __('* Bật thanh trượt khi có nhiều biến thể'),
                'options'       => array(
                    'off'       => __('On'),
                    'on'       => __('Off'),
                )
            ));

            ?>
        </div>
<?php
    }

    public function isures_variation_save_fields_in_tab($post_id)
    {
        if (isset($_POST['_scroll_on_off']))
            update_post_meta($post_id, '_scroll_on_off', esc_attr($_POST['_scroll_on_off']));
    }



    public function get_product_variation_price($variation_id)
    {

        global $woocommerce;
        $product = new WC_Product_Variation($variation_id);
        return $product->get_price_html(); // Works. Use this if you want the formatted price

    }

    public function variation_radio_buttons($html, $args)
    {
        $args = wp_parse_args(apply_filters('woocommerce_dropdown_variation_attribute_options_args', $args), array(
            'options'          => false,
            'attribute'        => false,
            'product'          => false,
            'selected'         => false,
            'name'             => '',
            'id'               => '',
            'class'            => '',
            'show_option_none' => __('Choose an option', 'woocommerce'),
        ));

        if (false === $args['selected'] && $args['attribute'] && $args['product']) {
            $selected_key     = 'attribute_' . sanitize_title($args['attribute']);
            $args['selected'] = isset($_REQUEST[$selected_key]) ? wc_clean(wp_unslash($_REQUEST[$selected_key])) : $args['product']->get_variation_default_attribute($args['attribute']);
        }

        $options               = $args['options'];
        $product               = $args['product'];
        $attribute             = $args['attribute'];
        $name                  = $args['name'] ? $args['name'] : 'attribute_' . sanitize_title($attribute);
        $id                    = $args['id'] ? $args['id'] : sanitize_title($attribute);
        $class                 = $args['class'];
        $show_option_none      = (bool) $args['show_option_none'];
        $show_option_none_text = $args['show_option_none'] ? $args['show_option_none'] : __('Choose an option', 'woocommerce');

        if (empty($options) && !empty($product) && !empty($attribute)) {
            $attributes = $product->get_variation_attributes();
            $options    = $attributes[$attribute];
        }
        global $post;
        $post_id = $post->ID;
        $scroll = get_post_meta( $post_id, '_scroll_on_off', true );
        if($scroll == 'on'){
            $scroll =  'scroll-on';
        }else{
            $scroll =  'scroll-off';
        }
        $radios = '<div class="isures-radio-variable '.$scroll.'">';


        if (!empty($options)) {



            $attributes = $product->get_available_variations();
            foreach ($attributes as $check) {
                $count_variation = count($check['attributes']);
            }
            if ($count_variation < 2) {
                foreach ($product->get_available_variations() as $text) {
                    // dump_data();


                    foreach (array_keys($text['attributes']) as $name_attr) {
                        if ($name_attr != 'attribute_pa') {
                            $get_term_tax = str_replace('attribute_', '', $name_attr);
                            $meta = get_post_meta($text['variation_id'], $name_attr, true);
                            $term = get_term_by('slug', $meta, $get_term_tax);

                            // var_dump($term);
                            if ($term == true) {
                                $var_name = $term->name;
                                $variation_names[] = $var_name;

                                // var_dump($meta);
                                $checked    = sanitize_title($args['selected']) === $args['selected'] ? checked($args['selected'], $name_attr, false) : checked($args['selected'], $name_attr, false);
                                $radios .= '<label class="isures-option">';
                                $radios    .= '<input type="radio" name="' . esc_attr($name) . '" value="' . sanitize_title($var_name) . '" ' . $checked . '>';
                                $radios .= '<span class="option-child">' . $var_name . '</span>';
                                $radios .= $text['price_html'];

                                $radios .= '</label>';
                            } else {
                                $checked    = sanitize_title($args['selected']) === $args['selected'] ? checked($args['selected'], $name_attr, false) : checked($args['selected'], $name_attr, false);
                                $radios .= '<label class="isures-option">';
                                $radios    .= '<input type="radio" name="' . esc_attr($name) . '" value="' . $meta . '" ' . $checked . '>';
                                $radios .= '<span class="option-child">' . $meta . '</span>';
                                $radios .= $text['price_html'];

                                $radios .= '</label>';
                                // var_dump($meta);
                            }
                        }
                    }
                }
            } else {
                foreach ($options as $option) {
                    $get_term_tax = str_replace('attribute_', '', $name);
                    $term = get_term_by('slug', $option, $get_term_tax);
                    if ($term == true) {
                        $var_name = $term->name;
                        $variation_names[] = $var_name;

                        $checked    = sanitize_title($args['selected']) === $args['selected'] ? checked($args['selected'], $option, false) : checked($args['selected'], $option, false);
                        $radios .= '<label class="isures-option">';
                        $radios    .= '<input type="radio" name="' . esc_attr($name) . '" value="' . sanitize_title($var_name) . '" ' . $checked . '>';
                        $radios .= '<span class="option-child">' . $var_name . '</span>';

                        $radios .= '</label>';
                    } else {
                        $checked    = sanitize_title($args['selected']) === $args['selected'] ? checked($args['selected'], $option, false) : checked($args['selected'], $option, false);
                        $radios .= '<label class="isures-option">';
                        $radios    .= '<input type="radio" name="' . esc_attr($name) . '" value="' . $option . '" ' . $checked . '>';
                        $radios .= '<span class="option-child">' . $option . '</span>';

                        $radios .= '</label>';
                    }
                }
            }
        }

        $radios .= '</div>';

        return $html . $radios;
    }

    public function variation_check($active, $variation)
    {
        if (!$variation->is_in_stock() && !$variation->backorders_allowed()) {
            return false;
        }
        return $active;
    }


    public function isures_reg_script()
    {

        wp_enqueue_script('isures-script-variation', ISURES_ELM . '/assets/js//variation.js', array('jquery'), '1.0', true);
        wp_enqueue_style('isures-style-variation', ISURES_ELM . '/assets/css//variation.css');
        wp_enqueue_style('isures-font-awesome', ISURES_ELM . '/assets/css//all.min.css');
    }


}

new isures_variation_product();
